## Flow

You can create a simple app with the following code:

```Python 
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, flowui
class App:
    
    class Config(plus.AppInMemory.Config):
        is_horizontal = False
        height = "800px"

    @mark_create_layout
    def my_layout(self):
        self.node_add_cnt = 0
        graph = flowui.Flow([], [], [
            flowui.MiniMap(),
            flowui.Controls(),
            flowui.Background()
        ])
        self.graph = graph
        graph.event_drop.on(self._handle_drop_event)
        return mui.VBox([
            graph.prop(droppable=True, allowedDndTypes=["FlowNodeItem"]),
            mui.VBox([
                mui.HBox([
                    mui.Typography("Input")
                ]).prop(border="1px solid red", draggable=True,
                  dragType="FlowNodeItem", dragData={"type": "input"}),
                mui.HBox([
                    mui.Typography("Output")
                ]).prop(border="1px solid blue", draggable=True,
                  dragType="FlowNodeItem", dragData={"type": "output"}),
                mui.HBox([
                    mui.Typography("Default")
                ]).prop(border="1px solid green", draggable=True,
                  dragType="FlowNodeItem", dragData={"type": "default"}),
            ]),
        ]).prop(width="100%", height="100%", overflow="hidden")


    async def _handle_drop_event(self, drop_data):
        data = drop_data["data"]
        node_type = data["type"]
        new_node = flowui.Node(type=node_type, id=self.graph.create_unique_node_id("node"), data=flowui.NodeData(label=node_type), 
            position=flowui.XYPosition(drop_data["clientOffset"]["x"], drop_data["clientOffset"]["y"]))
        await self.graph.add_node(new_node, screen_to_flow=True)

```

